\NeedsTeXFormat{LaTeX2e}

\ProvidesClass{smai_abstract}[2021/01/07 Classe pour les abstracts des congres SMAI, V1.1]

% classe de base

\LoadClass[a4paper, 11pt]{article}

% extensions

\RequirePackage[utf8]{inputenc}
\RequirePackage[T1]{fontenc}
\RequirePackage{lmodern}
\RequirePackage{graphicx}
\RequirePackage[frenchb]{babel}
\RequirePackage{geometry}
\RequirePackage{nopageno}
\RequirePackage{titling}
\RequirePackage{tikz}
\RequirePackage{titlecaps}
\RequirePackage{etoolbox}
\RequirePackage{amsmath}
\RequirePackage{amsthm}


\newtheorem{theorem}{Théorème}
\newtheorem{corollary}[theorem]{Corollaire}
\newtheorem{lemma}[theorem]{Lemme}
\newtheorem{proposition}[theorem]{Proposition}


\theoremstyle{definition}
\newtheorem{definition}{Definition}[section]

\theoremstyle{remark}
\newtheorem*{remark}{Remark}



\geometry{lmargin=2cm,rmargin=2cm,top=2cm,bottom=2cm}
\RequirePackage{fancyhdr}
\setlength{\headheight}{15.2pt}
\pagestyle{fancyplain}

\pretitle{\hrulefill\\ \begin{center}}
\postauthor{\end{tabular}\par\end{center}}
\predate{}
\postdate{}
\setlength{\droptitle}{-36pt}
\setlength{\parindent}{0pt}

\newcommand\@email{}

\renewcommand\@date{}

\renewcommand\@author{}

\newcommand\titre[1]{
  \title{\Large{\bf #1}}
}

% Pour les contribs standard

\newcommand{\auteur}[4]{
  \g@addto@macro\@author{\mbox{{\bf \titlecap{#2} \uppercase{#1}}, #3 - #4} \and }
}

\newcommand{\orateur}[5]{
  \g@addto@macro\@author{\mbox{\underline{\bf \titlecap{#2} \uppercase{#1}}, #3 - #4} \and }
  \g@addto@macro\@email{#5}
}

% Pour les minisymposiums

\newcommand{\organisateur}[4]{
  \g@addto@macro\@author{\mbox{{\bf \titlecap{#2} \uppercase{#1}}, #3 - #4} \and }
}

\newcommand{\responsable}[5]{
  \g@addto@macro\@author{\mbox{\underline{\bf \titlecap{#2} \uppercase{#1}}, #3 - #4} \and }
  \g@addto@macro\@email{#5}
}

% Pour les stands partenaire

\newcommand{\animateur}[4]{
  \g@addto@macro\@author{\mbox{{\bf \titlecap{#2} \uppercase{#1}}, #3 - #4} \and }
}


\newcommand{\bibliographie}[1]{
  \newcommand\@biblio{#1}
}

\newcommand{\congres}[1]{
  \newcommand\@congres{#1}
}

\newcommand{\dates}[1]{
  \newcommand\@dates{#1}
  }

\chead[]{\@congres}
\lhead[]{{\logoSMAI{12pt}}}
\rhead[]{\@dates}
\cfoot[]{}


%%% Le logo de la SMAI au format TIKZ
\newcommand{\logoSMAI}[1]%
{
  \definecolor{col1}{RGB}{0,124,170}
  \definecolor{col2}{RGB}{0,84,118}
  \definecolor{col3}{RGB}{0,75,132}
  \definecolor{col4}{RGB}{0,160,210}
  \begin{tikzpicture}[x=#1,y=-#1]
    \draw[col2,fill=col2]
    (3.07208,1.19407)
    .. controls (3.27227,1.14244) and (3.56863,1.09536) .. (3.87508,1.05069)
    .. controls (6.12113,0.72285) and (8.50496,0.71643) .. (8.50496,0.71643)
    -- (8.73609,0)
    .. controls (8.73609,0) and (6.8088,0.14096) .. (5.24889,0.39519)
    .. controls (4.62781,0.49644) and (3.57541,0.72497) .. (3.07161,1.19318)
    -- (3.07208,1.19407) --cycle;

    \draw[col1,fill=col1] (2.05155,2.83637)
    .. controls (2.05166,2.83572) and (2.05178,2.83519) .. (2.05184,2.83466)
    .. controls (2.09781,2.61219) and (2.12957,2.37281) .. (2.15986,2.18194)
    .. controls (2.22952,1.74307) and (2.25869,1.40469) .. (3.06894,1.19489)
    -- (3.06835,1.19619)
    .. controls (3.0476,1.21575) and (3.02769,1.23567) .. (3.00889,1.25606)
    .. controls (2.54999,1.75079) and (2.37207,2.39868) .. (2.37207,2.39868)
    .. controls (2.37207,2.39868) and (2.25539,2.77272) .. (2.05325,2.83613)
    -- (2.05155,2.83637) --cycle;

    \draw[col2,fill=col2]
    (1.7605,1.78027)
    .. controls (1.72738,1.85794) and (1.69668,1.92495) .. (1.67152,1.97657)
    .. controls (1.39701,2.53896) and (1.15304,3.27684) .. (1.56338,3.47673)
    .. controls (1.82992,3.60656) and (1.96517,3.2525) .. (2.05097,2.8385)
    -- (2.05145,2.83638)
    -- (2.04962,2.83727)
    .. controls (1.97472,2.85931) and (1.88443,2.85931) .. (1.78791,2.76172)
    .. controls (1.649,2.62116) and (1.71654,2.18831) .. (1.76144,1.78033)
    -- (1.7605,1.78027) --cycle;

    \draw[col1,fill=col1]
    (1.76205,1.77525)
    .. controls (1.83294,1.12847) and (1.82634,0.54841) .. (0.8921,0.98073)
    .. controls (0.50769,1.15853) and (0.32418,1.37086) .. (0.04367,1.68214)
    -- (0,0.94337)
    .. controls (0,0.94337) and (0.18357,0.68808) .. (0.87702,0.43379)
    .. controls (1.08575,0.35724) and (1.28465,0.30072) .. (1.60488,0.27957)
    .. controls (2.33268,0.23136) and (1.99665,1.22424) .. (1.76264,1.77548)
    -- (1.76205,1.77525) --cycle;

    \draw[col2,fill=col2]
    (4.18874,2.63827)
    .. controls (4.18874,2.78159) and (4.13488,2.89574) .. (4.02709,2.98061)
    .. controls (3.92815,3.05674) and (3.80457,3.09476) .. (3.65618,3.09476)
    .. controls (3.44573,3.09476) and (3.28597,3.03518) .. (3.17689,2.91602)
    .. controls (3.13888,2.87412) and (3.11984,2.83422) .. (3.11984,2.79615)
    .. controls (3.11984,2.76568) and (3.12962,2.7391) .. (3.14931,2.7163)
    .. controls (3.16899,2.69343) and (3.19404,2.68206) .. (3.2245,2.68206)
    .. controls (3.24596,2.68206) and (3.27707,2.69809) .. (3.31768,2.73015)
    .. controls (3.37466,2.77364) and (3.41774,2.80251) .. (3.44697,2.81654)
    .. controls (3.50908,2.84866) and (3.57627,2.86463) .. (3.64857,2.86463)
    .. controls (3.72972,2.86463) and (3.79879,2.84748) .. (3.8559,2.813)
    .. controls (3.92308,2.77234) and (3.95667,2.71371) .. (3.95667,2.63727)
    .. controls (3.95667,2.55954) and (3.92119,2.50668) .. (3.85024,2.47869)
    .. controls (3.8058,2.46077) and (3.73733,2.45187) .. (3.6448,2.45187)
    .. controls (3.33029,2.45187) and (3.17306,2.32959) .. (3.17306,2.08485)
    .. controls (3.17306,1.96056) and (3.2245,1.8648) .. (3.32716,1.79762)
    .. controls (3.41462,1.73933) and (3.5237,1.7101) .. (3.65429,1.7101)
    .. controls (3.73544,1.7101) and (3.81217,1.72283) .. (3.88442,1.74817)
    .. controls (3.98207,1.78241) and (4.03092,1.83256) .. (4.03092,1.89845)
    .. controls (4.03092,1.92762) and (4.02137,1.95237) .. (4.00234,1.97264)
    .. controls (3.98336,1.99292) and (3.9592,2.00305) .. (3.93003,2.00305)
    .. controls (3.91229,2.00305) and (3.88825,1.99669) .. (3.85784,1.98402)
    .. controls (3.78677,1.95485) and (3.71711,1.94035) .. (3.64857,1.94035)
    .. controls (3.48628,1.94035) and (3.40519,1.98855) .. (3.40519,2.08485)
    .. controls (3.40519,2.14826) and (3.43683,2.18945) .. (3.50024,2.20849)
    .. controls (3.53189,2.21733) and (3.58958,2.22175) .. (3.67327,2.22175)
    .. controls (3.82419,2.22175) and (3.944,2.25286) .. (4.03275,2.31503)
    .. controls (4.13676,2.38599) and (4.18874,2.49377) .. (4.18874,2.63827)
     --cycle;

    \draw[col3,fill=col3]
    (5.63401,2.99586)
    .. controls (5.63401,3.02627) and (5.62229,3.05037) .. (5.59877,3.06817)
    .. controls (5.57532,3.08591) and (5.54774,3.09475) .. (5.51609,3.09475)
    .. controls (5.48563,3.09475) and (5.45964,3.08649) .. (5.43807,3.07005)
    .. controls (5.41650,3.05355) and (5.40571,3.03075) .. (5.40571,3.00157)
    -- (5.40571,2.29970)
    .. controls (5.40571,2.29086) and (5.40129,2.28638) .. (5.39245,2.28638)
    .. controls (5.38733,2.28638) and (5.38037,2.29210) .. (5.37153,2.30353)
    .. controls (5.35757,2.32380) and (5.33671,2.35557) .. (5.30871,2.39859)
    .. controls (5.28090,2.44179) and (5.23705,2.50767) .. (5.17753,2.59642)
    .. controls (5.15973,2.62306) and (5.14200,2.65040) .. (5.12426,2.67822)
    .. controls (5.10145,2.70609) and (5.07417,2.72006) .. (5.04246,2.72006)
    .. controls (5.00698,2.72006) and (4.97846,2.70609) .. (4.95695,2.67822)
    .. controls (4.94676,2.66561) and (4.89790,2.59070) .. (4.81045,2.45381)
    .. controls (4.73820,2.34095) and (4.69759,2.28450) .. (4.68870,2.28450)
    .. controls (4.67986,2.28450) and (4.67538,2.29021) .. (4.67538,2.30165)
    -- (4.67538,3.00157)
    .. controls (4.67538,3.03075) and (4.66465,3.05355) .. (4.64308,3.07005)
    .. controls (4.62146,3.08649) and (4.59547,3.09475) .. (4.56506,3.09475)
    .. controls (4.53341,3.09475) and (4.50577,3.08591) .. (4.48238,3.06817)
    .. controls (4.45886,3.05037) and (4.44720,3.02627) .. (4.44720,2.99586)
    -- (4.44720,1.85848)
    .. controls (4.44720,1.82041) and (4.45763,1.78782) .. (4.47855,1.76054)
    .. controls (4.49947,1.73325) and (4.52899,1.71964) .. (4.56700,1.71964)
    .. controls (4.60755,1.71964) and (4.63802,1.73579) .. (4.65829,1.76814)
    .. controls (4.67856,1.80049) and (4.70773,1.84770) .. (4.74580,1.90981)
    -- (4.90362,2.16652)
    .. controls (4.92519,2.20588) and (4.96072,2.26364) .. (5.01017,2.33966)
    .. controls (5.02284,2.35616) and (5.03362,2.36435) .. (5.04246,2.36435)
    .. controls (5.05006,2.36435) and (5.06026,2.35521) .. (5.07287,2.33677)
    .. controls (5.08554,2.31844) and (5.11666,2.26870) .. (5.16616,2.18756)
    -- (5.33541,1.90981)
    .. controls (5.35309,1.87811) and (5.38108,1.83126) .. (5.41909,1.76908)
    .. controls (5.44060,1.73614) and (5.47225,1.71964) .. (5.51415,1.71964)
    .. controls (5.55222,1.71964) and (5.58174,1.73325) .. (5.60266,1.76054)
    .. controls (5.62352,1.78782) and (5.63401,1.82041) .. (5.63401,1.85848)
    -- (5.63401,2.99586) --cycle;

    \draw[col1,fill=col1]
    (7.09697,2.97304)
    .. controls (7.09697,3.00480) and (7.08530,3.03197) .. (7.06190,3.05477)
    .. controls (7.03845,3.07752) and (7.01105,3.08890) .. (6.97940,3.08890)
    .. controls (6.93638,3.08890) and (6.90226,3.06556) .. (6.87698,3.01889)
    .. controls (6.87061,3.00250) and (6.86054,2.97881) .. (6.84669,2.94787)
    .. controls (6.83272,2.91693) and (6.81186,2.86997) .. (6.78404,2.80685)
    .. controls (6.77774,2.78917) and (6.76760,2.76359) .. (6.75369,2.73012)
    .. controls (6.73973,2.69677) and (6.72016,2.67997) .. (6.69488,2.67997)
    .. controls (6.65316,2.67997) and (6.59116,2.67938) .. (6.50895,2.67809)
    -- (6.32314,2.67809)
    .. controls (6.29904,2.67809) and (6.28389,2.67938) .. (6.27759,2.68197)
    .. controls (6.26751,2.68704) and (6.25731,2.69924) .. (6.24730,2.71845)
    .. controls (6.24223,2.73118) and (6.23457,2.75104) .. (6.22449,2.77792)
    .. controls (6.21017,2.81210) and (6.18813,2.86325) .. (6.15837,2.93143)
    .. controls (6.15200,2.94770) and (6.14181,2.97204) .. (6.12784,3.00457)
    .. controls (6.09855,3.06084) and (6.05913,3.08890) .. (6.00945,3.08890)
    .. controls (5.97763,3.08890) and (5.95063,3.07817) .. (5.92836,3.05666)
    .. controls (5.90608,3.03515) and (5.89494,3.00916) .. (5.89494,2.97881)
    .. controls (5.89494,2.96102) and (5.89878,2.94275) .. (5.90638,2.92377)
    .. controls (5.92412,2.88069) and (5.95069,2.81551) .. (5.98623,2.72812)
    -- (6.30010,1.95158)
    .. controls (6.31147,1.91987) and (6.33045,1.87296) .. (6.35714,1.81085)
    .. controls (6.38879,1.74361) and (6.43446,1.70996) .. (6.49410,1.70996)
    .. controls (6.55368,1.70996) and (6.59988,1.74290) .. (6.63288,1.80879)
    .. controls (6.64685,1.84297) and (6.66771,1.89424) .. (6.69565,1.96260)
    -- (6.79648,2.21147)
    .. controls (6.85989,2.36722) and (6.95565,2.60083) .. (7.08371,2.91228)
    .. controls (7.09249,2.93385) and (7.09697,2.95406) .. (7.09697,2.97304)
     --cycle;
    
    
    \draw[col4,fill=col4]
    (7.88811,2.96714)
    .. controls (7.88811,2.99891) and (7.87857,3.02525) .. (7.85953,3.04605)
    .. controls (7.84050,3.06697) and (7.81516,3.07752) .. (7.78351,3.07752)
    -- (7.43923,3.07752)
    .. controls (7.40753,3.07752) and (7.38219,3.06644) .. (7.36315,3.04423)
    .. controls (7.34418,3.02201) and (7.33463,2.99449) .. (7.33463,2.96149)
    .. controls (7.33463,2.93102) and (7.34253,2.90438) .. (7.35838,2.88158)
    .. controls (7.37423,2.85877) and (7.39680,2.84740) .. (7.42591,2.84740)
    .. controls (7.47406,2.84740) and (7.49816,2.81439) .. (7.49816,2.74845)
    -- (7.49816,2.03332)
    .. controls (7.49816,1.98004) and (7.48084,1.95346) .. (7.44619,1.95346)
    .. controls (7.41159,1.95346) and (7.38431,1.94362) .. (7.36445,1.92394)
    .. controls (7.34459,1.90432) and (7.33463,1.87797) .. (7.33463,1.84503)
    .. controls (7.33463,1.81203) and (7.34482,1.78380) .. (7.36527,1.76041)
    .. controls (7.38572,1.73695) and (7.41183,1.72516) .. (7.44377,1.72516)
    -- (7.77703,1.72516)
    .. controls (7.81021,1.72516) and (7.83702,1.73565) .. (7.85747,1.75657)
    .. controls (7.87792,1.77750) and (7.88811,1.80449) .. (7.88811,1.83743)
    .. controls (7.88811,1.86919) and (7.87851,1.89612) .. (7.85924,1.91822)
    .. controls (7.83997,1.94044) and (7.81433,1.95152) .. (7.78227,1.95152)
    .. controls (7.74503,1.95152) and (7.72640,1.98452) .. (7.72640,2.05041)
    -- (7.72640,2.75605)
    .. controls (7.72640,2.81817) and (7.74550,2.84928) .. (7.78351,2.84928)
    .. controls (7.81516,2.84928) and (7.84050,2.86101) .. (7.85953,2.88446)
    .. controls (7.87857,2.90792) and (7.88811,2.93550) .. (7.88811,2.96714)
     --cycle;
  \end{tikzpicture}
}


\AtBeginDocument{
  \maketitle
}


\AtEndDocument{
  \vfill
  \ifundef{\@biblio}{ % Y'A PAS DE BIBLIO
  }%
  { % Y'A UNE BIBLIO
  \renewcommand{\refname}{}
  \bibliographystyle{smai}
  \bibliography{\@biblio}
\medskip
}

\underline{Contact :} {\tt \@email}
}